<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
* @package direct-as-a-service
* @subpackage controllers
* @filesource
*//** */
 
require_once 'mailbox_controller.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Group_controller extends Mailbox_controller{
	
	public function update_group_post(){
		$required_fields = array('display_name','description','facility_id');
		$post = $this->post();
		foreach($required_fields as $required_field){
			if(array_key_exists($required_field, $post)){
				$$required_field = $this->post($required_field,TRUE);
			}
			else{
				array_push($this->missing_required_fields, $required_field);
			}
		}
		//if there is an error with the passed in fields create an error message
		$this->respond_with_error_if_fields_are_missing();
		$this->respond_with_error_if_user_is_unauthorized('manage');
		$this->respond_with_error_if_mailbox_is_inactive();
		if(empty($display_name)){
			$this->invalid_fields[] = 'display_name';
		}
		if(empty($description)){
			$this->invalid_fields[] = 'description';
		}
		if($facility_id && !is_numeric($facility_id)){
			$this->invalid_fields[] = 'facility_id';
		}
		$group_name = $this->mailbox->name;
		$group = $this->groupsmodel->get_group_from_groupname($group_name);
		if(!isset($group[0])){
			$group = $this->groupsmodel->get_group_from_groupname($group_name, false);
			if(!isset($group[0])){
				$this->invalid_fields[] = 'mailbox';	
			}
		}
		$this->respond_with_error_if_fields_are_invalid();
		$result = $this->groupsmodel->update_group($group_name, $display_name, $description);
		$save_facility_result = $this->usersettingsmodel->update_facility_id_in_mailbox($group_name, true, $facility_id);
		if($result){
			$this->response("Group information updated", 200);
		}
		else{
			$this->response("Group information failed to updated", 500);
		}
		
	}
	public function group_get(){
		$this->load->model('facilitymodel');
		$this->respond_with_error_if_fields_are_missing();
		$this->respond_with_error_if_user_is_unauthorized('manage');
		$group_name = $this->mailbox->name;
		$group = $this->groupsmodel->get_group_from_groupname($group_name);
		if(!isset($group[0])){
			$group = $this->groupsmodel->get_group_from_groupname($group_name, false);
			if(!isset($group[0])){
				$this->invalid_fields[] = 'mailbox';	
			}
		}
		$return_values = array('cn' => 'display_name','description' => 'description');
		foreach ($return_values as $key => $value){
			$data[$value] = $group[0][$key];
		}
		$data['facility_id'] = $this->usersettingsmodel->get_facility_id_in_mailbox($group_name, true);
		$data['facilities'] = $this->facilitymodel->get_facilities(true)->result();
		$this->respond_with_error_if_fields_are_invalid();
		$this->response($data, 200);
	}
	public function groups_in_facility_get(){
		$this->load->model('facilitymodel');
		$this->respond_with_error_if_fields_are_missing();
		$this->respond_with_error_if_user_is_unauthorized('manage');
		$user = User::find_one(array('username' => $this->mailbox->name));
		if(!User::is_an_entity($user)){
			$this->invalid_fields[] = 'mailbox';
		}
		$this->respond_with_error_if_fields_are_invalid();
		$user_data = $this->usersmodel->get_user($user->id);
		$data['facility_id'] = $this->usersettingsmodel->get_facility_id_in_mailbox($user_data->username, false);
		$accounts = array();
		if($data['facility_id'] !== null){
			$mailboxes = Mailbox::find(array("facility_id"=>$data['facility_id'],"is_group"=>1));
			$result = $this->applicationmodel->get_application($this->application_id);
			if($result){
				$name = $result->row_array()['name'];
				foreach ($mailboxes as $mailbox){
					$group = $this->groupsmodel->get_group_from_groupname($mailbox->name);
					if(count($group) === 0){
						$group = $this->groupsmodel->get_group_from_groupname($mailbox->name, false);
					}
					if(in_array($name, $group[0]['applications'])){
						$accounts[] = $mailbox->name;
					}
				}
			}
		}
		$data['accounts'] = $accounts;
		$this->response($data, 200);
	}
}

?>